﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class AI5620DigitalIO : UserControl
    {
        AI5620_TE_Simulator.DigitalIOManager DIO = null;

        public AI5620DigitalIO()
        {
            InitializeComponent();


            cbo_OutputA.Items.Clear();
            cbo_OutputB.Items.Clear();
            cbo_OutputC.Items.Clear();
            cbo_InputAMode.Items.Clear();

            foreach (AI5620_TE_Simulator.DigitalIOManager.OutputAState S in Enum.GetValues(typeof(AI5620_TE_Simulator.DigitalIOManager.OutputAState)))
            {
                cbo_OutputA.Items.Add(S);
            }

            foreach (AI5620_TE_Simulator.DigitalIOManager.OutputBState S in Enum.GetValues(typeof(AI5620_TE_Simulator.DigitalIOManager.OutputBState)))
            {
                cbo_OutputB.Items.Add(S);
            }

            foreach (AI5620_TE_Simulator.DigitalIOManager.OutputCState S in Enum.GetValues(typeof(AI5620_TE_Simulator.DigitalIOManager.OutputCState)))
            {
                cbo_OutputC.Items.Add(S);
            }


            foreach (AI5620_TE_Simulator.DigitalIOManager.InputAFunction S in Enum.GetValues(typeof(AI5620_TE_Simulator.DigitalIOManager.InputAFunction)))
            {
                cbo_InputAMode.Items.Add(S);
            }


            cbo_OutputA.SelectedIndex = 0;
            cbo_OutputB.SelectedIndex = 0;
            cbo_OutputC.SelectedIndex = 0;
            cbo_InputAMode.SelectedIndex = 0;

         

            this.EnabledChanged += new EventHandler(AI5620DigitalIOCtrl_EnabledChanged);
        }

        void AI5620DigitalIOCtrl_EnabledChanged(object sender, EventArgs e)
        {
            timer_Update.Enabled = this.Enabled;
        }


        public void SetDigitalIO(AI5620_TE_Simulator.DigitalIOManager DIO)
        {
            this.DIO = DIO;
            RefreshControls();
        }

        private void RefreshControls()
        {
            if (DIO == null) return;
            cbo_OutputA.SelectedItem = DIO.OutputA;
            cbo_OutputB.SelectedItem = DIO.OutputB;
            cbo_OutputC.SelectedItem = DIO.OutputC;
            cbo_InputAMode.SelectedItem = DIO.InputAMode;
        }

        private void timer_Update_Tick(object sender, EventArgs e)
        {
            try
            {
                if (DIO == null) return;
                Boolean[] Inputs = DIO.GetDigitalInputs();

                lbl_InputA.Text = Inputs[0].ToString();
                lbl_InputB.Text = Inputs[1].ToString();

            }
            catch { }
        }

        private void cbo_OutputA_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                if (DIO == null) return;
                DIO.OutputA = (AI5620_TE_Simulator.DigitalIOManager.OutputAState)cbo_OutputA.SelectedItem;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                RefreshControls();

            }
        }

        private void cbo_OutputB_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                if (DIO == null) return;
                DIO.OutputB = (AI5620_TE_Simulator.DigitalIOManager.OutputBState)cbo_OutputB.SelectedItem;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                RefreshControls();

            }
        }

        private void cbo_OutputC_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                if (DIO == null) return;
                DIO.OutputC = (AI5620_TE_Simulator.DigitalIOManager.OutputCState)cbo_OutputC.SelectedItem;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                RefreshControls();

            }
        }

        private void timer_Update_Tick_1(object sender, EventArgs e)
        {
            try
            {
                if (DIO == null) return;
                Boolean[] Inputs = DIO.GetDigitalInputs();

                lbl_InputA.Text = Inputs[0].ToString();
                lbl_InputB.Text = Inputs[1].ToString();
            }
            catch { }
        }

        private void cbo_InputAMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (DIO == null) return;
            DIO.InputAMode = (AI5620_TE_Simulator.DigitalIOManager.InputAFunction) cbo_InputAMode.SelectedItem;
        }

        private void btn_ResetToDefaults_Click(object sender, EventArgs e)
        {
            try
            {
                DIO.ResetToDefaults();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {

                RefreshControls();
            }
        }
    }
}
